import React from 'react';
import StyledButton from 'components/StyledButton';
import downloadSign from 'resources/images/download-sign.svg';
import useStyles from './styles';

type Props = {
    strings: object,
    onInstallUpdate: () => {}
};

function DownloadingUpdateComplete({ strings, onInstallUpdate }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.downloadingUpdateContainer}>
            <img
                className={classes.updateAvailableIcon}
                src={downloadSign}
                alt="Download complete icon"
            />
            <div className={classes.updateAvailableTitle}>
                {strings.welcome_downloading_app_update_complete}
            </div>
            <StyledButton
                variant="contained"
                btnSize="big"
                onClick={onInstallUpdate}
            >
                {strings.welcome_install_app_update}
            </StyledButton>
        </div>
    );
}

export default DownloadingUpdateComplete;
